#include "../../common/buffer.h"
#include "../../common/Color.h"
#include "../shaders.h"
#include "../../parse/parser.h"

#include "../../frontend/globals.h"

#include <stdlib.h>


typedef struct {
	vector3 old_pos;
	vector3 old_up;
	vector3 old_look;
} reproj_data;


int _init_reproj(void **data_ptr, char *input)
{
	reproj_data *rpd = (reproj_data*) malloc(sizeof(reproj_data));
	rpd->old_pos = main_scene->camera->pos;
	rpd->old_up = main_scene->camera->up;
	rpd->old_look = main_scene->camera->look;
	
	*data_ptr = (void*)rpd;
	return 1;
}

void reproject_sample(Color *oldColor, intersect_data& oldIntersection)
{
	vector3 newProjection = oldIntersection.intersect - main_scene->camera->pos;
	vector3 newCoords;
	
	main_scene->camera->getImageCoords(newCoords, newProjection);
	if(newCoords.c[0] < 0 || newCoords.c[0] > main_scene->width ||
	   newCoords.c[1] < 0 || newCoords.c[1] > main_scene->height)
		return;
	if(oldIntersection.normal.dot(newProjection) > 0)
		return;
	if(main_scene->camera->look.dot(newProjection) < 0)
		return;
	
	set_Color(newCoords.c[0], newCoords.c[1], oldColor);
}

void _run_reproj(void *data)
{
	reproj_data *rpd = (reproj_data*)data;

	intersect_data* ifront = main_scene->intersect_front;
	intersect_data* iback = main_scene->intersect_back;
	unsigned char *cfront = main_scene->Color_front;
	unsigned char *cback = main_scene->Color_back;
	int x,y;
	intersect_data old_i;
	intersect_data *new_i;
	Color new_c;
	Color old_c;
	static char filled = 0;
	
	if(filled == 0)
	for(y = 0; y < main_scene->height; y++)
	{
		for(x = 0; x < main_scene->width; x++)
		{
			//get the new data
			new_i = get_idata(x, y);
			
			//get the old data
			main_scene->intersect_front = iback;
			copy_hit_data(&old_i, get_idata(x, y) );

			//copy new data to back buffer
			copy_hit_data(get_idata(x, y), new_i);
			
			//swap buffer back to normal
			main_scene->intersect_front = ifront;
			
			//get the new Color
			get_Color(x, y, &new_c);
			
			//get the old Color
			main_scene->Color_front = cback;
			get_Color(x, y, &old_c);
			
			//copy new Color to old one
			set_Color(x, y, &new_c);
			
			main_scene->Color_front = cfront;
		}
	}
		
	//only use old samples
	if(filled)
	{
		Color black = Color(0,0,0);
		for(y = 0; y < main_scene->height; y++)
		{
			for(x = 0; x < main_scene->width; x++)
			{
				set_Color(x, y, &black);
			}
		}
		
		for(y = 0; y < main_scene->height; y++)
		{
			for(x = 0; x < main_scene->width; x++)
			{
				copy_hit_data(&old_i, get_idata(x, y) );

				//get the old Color
				main_scene->Color_front = cback;
				get_Color(x, y, &old_c);
				
				//render on front buffer
				main_scene->Color_front = cfront;

				//if(old_i.obj_num > 0) {
				if(old_i.obj != main_scene->background)
				{
					reproject_sample(&old_c, old_i);
				}
			}
		}
	}
	
	rpd->old_pos = main_scene->camera->pos;
	rpd->old_up = main_scene->camera->up;
	rpd->old_look = main_scene->camera->look;
	
	frontend->renderer = 8;
	filled = 1;
}


void _cleanup_reproj(void* data)
{
	free((reproj_data*)data);
	frontend->renderer = 18;
}

shader_data reproj =
{
	"reproj",
	"options:\n   reproj <float alpha>\n",
	(int (*)(void*, char*))_init_reproj,
	(void* (*)(void*))_run_reproj,
	(void* (*)(void*))_cleanup_reproj,
};

shader_data* get_reproj()
{
	return &reproj;
}
