#include "../../common/buffer.h"
#include "../../common/Color.h"
#include "../shaders.h"
#include "../../parse/parser.h"

#include "../../frontend/globals.h"

#include <stdlib.h>

extern Color black;

typedef struct {
	// camera data from n-2
	Camera cameraN2;
	
	// camera data from n-1
	Camera cameraN1;
	
	Color* ColorsN1;
	intersect_data* intersectN1;
	
} reproj_blur_data;


int _init_reproj_blur(void **data_ptr, char *input)
{
	reproj_blur_data *rpd = (reproj_blur_data*) malloc(sizeof(reproj_blur_data));
	
	rpd->ColorsN1 =
			(Color*)malloc(sizeof(Color)*main_scene->width*main_scene->height);
	memcpy(rpd->ColorsN1, main_scene->Color_front,
		   sizeof(Color)*main_scene->width*main_scene->height);
	rpd->intersectN1 = (intersect_data*)
			malloc(sizeof(intersect_data)*main_scene->width*main_scene->height);
	memcpy(rpd->intersectN1, main_scene->intersect_front,
		   sizeof(intersect_data)*main_scene->width*main_scene->height);
	
	memcpy(&rpd->cameraN1, main_scene->camera, sizeof(Camera));
	memcpy(&rpd->cameraN2, main_scene->camera, sizeof(Camera));
	
	
	*data_ptr = (void*)rpd;
	return 1;
}

inline char validReprojectCoords(vector3& newCoords, intersect_data* oldIntersection, Camera& c)
{
	vector3 newProjection = oldIntersection->intersect - c.pos;
	c.getImageCoords(newCoords, newProjection);
	
	if(oldIntersection->normal.dot(newProjection) > 0)
		return false;
	if(main_scene->camera->look.dot(newProjection) < 0)
		return false;
	if(newCoords.c[0] >= 0 || newCoords.c[0] <= main_scene->width ||
	   newCoords.c[1] >= 0 || newCoords.c[1] <= main_scene->height)
		return true;
	
	return false;
}

inline void reprojectBlur(reproj_blur_data *rpd, Camera &camFrom, Camera &camTo, intersect_data *intersects, unsigned char *Colors, unsigned char *output)
{
	intersect_data *intersectN1;
	int x,y;
	Camera reprojCamera;
	memcpy(&reprojCamera, &rpd->cameraN1, sizeof(Camera));
	float numSamples = 5.0f;
	Color ColorN1;
	
	main_scene->intersect_front = intersects;
	
	for(int i=0; i<numSamples; i++)
	{
		vector3 newCoords;
		const float fromAmount = i/numSamples;
		const float toAmount = (1.0f-fromAmount);
		reprojCamera.pos = camFrom.pos*toAmount + camTo.pos*fromAmount;
		reprojCamera.horz = camFrom.horz*toAmount + camTo.horz*fromAmount;
		reprojCamera.vert = camFrom.vert*toAmount + camTo.vert*fromAmount;
		reprojCamera.topLeftCorner = camFrom.topLeftCorner*toAmount + camTo.topLeftCorner*fromAmount;
		
		for(y = 0; y < main_scene->height; y++)
		{
			for(x = 0; x < main_scene->width; x++)
			{				
				//get the old Color from the last frome buffer
				main_scene->Color_front = Colors;
				get_Color(x, y, &ColorN1);
				main_scene->Color_front = output;
				
				//get the intersection data
				intersectN1 = get_idata(x, y);
				
				
				if(validReprojectCoords(newCoords, intersectN1, reprojCamera))
				{
					Color outColorN1;
					get_Color(newCoords.c[0], newCoords.c[1], &outColorN1);
					outColorN1 = ColorN1*0.4 + outColorN1*0.6f;
					set_Color(newCoords.c[0], newCoords.c[1], &outColorN1);
				}
			}
		}
	}
}

void _run_reproj_blur(void *data)
{
	reproj_blur_data *rpd = (reproj_blur_data*)data;
	
	intersect_data *ifront = main_scene->intersect_front;
	unsigned char *frameN1 = (unsigned char*)rpd->ColorsN1;
	unsigned char *frameN0 = main_scene->Color_front;
	unsigned char *outputN1 = main_scene->Color_back;
	
	Camera &camN2 = rpd->cameraN2;
	Camera &camN1 = rpd->cameraN1;
	Camera &camN0 = *main_scene->camera;
	
	int x,y;
	
	//only use old samples
	main_scene->Color_front = outputN1;
	for(y = 0; y < main_scene->height; y++)
	{
		for(x = 0; x < main_scene->width; x++)
		{
			//set_Color(x, y, &black);
		}
	}
	
	reprojectBlur(rpd, camN2, camN1, rpd->intersectN1, frameN1, outputN1);
	reprojectBlur(rpd, camN0, camN1, rpd->intersectN1, frameN1, outputN1);
	
	main_scene->intersect_front = ifront;

	memcpy(&rpd->cameraN2, &rpd->cameraN1, sizeof(Camera));
	memcpy(&rpd->cameraN1, main_scene->camera, sizeof(Camera));
	main_scene->camera->handleInput(20.0f, 0.0f);
	
	memcpy(rpd->ColorsN1, frameN0,
		   sizeof(Color)*main_scene->width*main_scene->height);
	main_scene->Color_front = outputN1;
	main_scene->Color_back = frameN0;
	memcpy(rpd->intersectN1, main_scene->intersect_front,
		   sizeof(intersect_data)*main_scene->width*main_scene->height);
}


void _cleanup_reproj_blur(void* data)
{
	free((reproj_blur_data*)data);
}

shader_data reproj_blur =
{
	"reproj_blur",
	"options:\n   reproj_blur <float alpha>\n",
	(int (*)(void*, char*))_init_reproj_blur,
	(void* (*)(void*))_run_reproj_blur,
	(void* (*)(void*))_cleanup_reproj_blur,
};

shader_data* get_reproj_blur()
{
	return &reproj_blur;
}