#include "../../common/buffer.h"
#include "../../common/Color.h"
#include "../shaders.h"
#include <stdio.h>


int _init_simple(void **data_ptr, char *input)
{
	return 1;
}


void _cleanup_simple(void* data)
{
}

void _run_greyscale(void *data)
{
	int x,y;
	Color c;
	float bw;

	for(y = 0; y < main_scene->height; y++)
		for(x = 0; x < main_scene->width; x++)
		{
			get_Color(x, y, &c);
			bw = (float)(c.r + c.g + c.b)/3.0;
			c.r = bw;
			c.g = bw;
			c.b = bw;
			set_Color(x, y, &c);
		}
}

void _run_invert(void *data)
{
	
	int x,y;
	Color c;
	Color n;

	for(y = 0; y < main_scene->height; y++)
		for(x = 0; x < main_scene->width; x++)
		{
			get_Color(x, y, &c);
			n.r = 256.0 - c.r;
			n.g = 256.0 - c.g;
			n.b = 256.0 - c.b;
			set_Color(x, y, &n);
		}
}


shader_data greyscale =
{
	"greyscale",
	"greyscale has no options\n",
	(int (*)(void*, char*))_init_simple,
	(void* (*)(void*))_run_greyscale,
	(void* (*)(void*))_cleanup_simple,
};

shader_data* get_greyscale()
{
	return &greyscale;
}



shader_data invert =
{
	"invert",
	"invert has no options\n",
	(int (*)(void*, char*))_init_simple,
	(void* (*)(void*))_run_invert,
	(void* (*)(void*))_cleanup_simple,
};

shader_data* get_invert()
{
	return &invert;
}

