#include "../common/buffer.h"
#include "../common/debug.h"
#include "../common/Color.h"
#include "shaders.h"
#include <stdlib.h>

extern SlimScene* main_scene;
extern system_data* sys;





void old_run_post_shaders()
{
	//float m[9] = {1,2,1,2,4,2,1,2,1};
	//float m[125] = {1,4,6,4,1,4,16,24,16,4,6,24,36,24,6,4,16,24,16,4,1,4,6,4,1};
	//float m[9] = {0,-1,0,-1,5,-1,-0,-1,-0};
	//float m[9] = {-1,-1,-1,0,0,0,1,1,1};
	//float m[9] = {0,0,0,0,0,0,0,0,0};
	//float m[9] = {0,0,0,0,1,0,0,0,-1};
	//black_white();
	//invert();
	//blur(5);
	//bloom(150, 1.7);
	//blend_frame();
	//convolve(1,1, m);
	
//	hilight_PrimitiveBase(6);
}


#define MAX_POST_SHADERS_OLD 20


int number_of_post_shaders = 0;
shader_data* post_shaders[MAX_POST_SHADERS_OLD];

int add_post_shader(shader_data *shdr, char *data_string)
{
	int i;
	shader_data *shader = (shader_data*)malloc(sizeof(shader_data));

	shader->init = shdr->init;
	shader->run = shdr->run;
	shader->cleanup = shdr->cleanup;
	
	if(shader->init(&shader->data, data_string) == 0)
		return -1;
	
	for(i=0; i<MAX_POST_SHADERS_OLD ;i++)
	{
		if(post_shaders[i] == NULL)
		{
			post_shaders[number_of_post_shaders] = shader;
			break;
		}
	}
	
	number_of_post_shaders++;
	
	return i;
}

void remove_post_shader(int num)
{
	shader_data *shader;
	
	if(post_shaders[num] == NULL || num > MAX_POST_SHADERS_OLD - 1 || num < 0)
		return;
	
	shader = post_shaders[num];
	shader->cleanup(shader->data);
	free(shader);
	post_shaders[num] = NULL;
	number_of_post_shaders--;
}

void run_post_shaders_old()
{
	int i=0;
	
	for(i=0; i<MAX_POST_SHADERS_OLD; i++)
	{
		if(post_shaders[i] != NULL)
			post_shaders[i]->run(post_shaders[i]->data);
	}
}

void run_post_shaders()
{
	int i=0;
	shader_data *shader;
	
	for(i=0; i< sys->active_post_shaders.item_count; i++)
	{
		shader = (shader_data*)list_get_index(&sys->active_post_shaders, i);
		shader->run(shader->data);
	}
}
