#include "shaders.h"
#include <string.h>
#include <stdlib.h>
#include "../common/Vector3.h"
#define MAX_SHADERS 200
/*
shader_data *shaders[MAX_MAX_SHADERS];
shader_data* running_shaders[MAX_MAX_SHADERS]

void set_shader(char *name, void *run, void *setup, void *cleanup)
{
	shaders[shader_num] = malloc(sizeof(shader_data));
	shaders[shader_num]->run = run;
	shaders[shader_num]->setup = setup;
	shaders[shader_num]->cleanup = cleanup;
}

void setup_shader(char* name)
{ }

void cleanup_shader(char* name)
{ }

void setup_all_shaders(char* name)
{ }

void cleanup_all_shaders(char* name)
{ }

void*[3] get_shader_ptrs(char* name)
{ }
*/
void copy_hit_data(intersect_data *dest, intersect_data *source)
{
	dest->pos = vector3(source->pos);
	dest->start = vector3(source->start);
	dest->intersect = vector3(source->intersect);
	dest->proj = vector3(source->proj);
	dest->normal = vector3(source->normal);
	dest->obj = source->obj;
	dest->obj_num = source->obj_num;
	dest->step = source->step;
	dest->distance = source->distance;
}

void fill_in_next_hit_data(intersect_data *dest, intersect_data *source)
{
	dest->start = vector3(source->intersect);
	//dest->intersect = vector3(source->intersect);
	//dest->proj = vector3(source->proj);
	//dest->normal = vector3(source->normal);
	//dest->reflect = vector3(source->reflect);
	dest->obj = source->obj;
	dest->other_obj_num = source->other_obj_num;
	dest->obj_num = -1;
	dest->distance = 0;
	dest->step = source->step + 1;
	dest->pos.c[0] = 0;
	dest->pos.c[1] = 0;
}

int number_of_shaders = 0;
shader_data* shaders[MAX_SHADERS];


void register_shader(shader_data *shader)
{
	shaders[number_of_shaders] = shader;
	number_of_shaders++;
}

char* list_shaders()
{
	int i;

	for(i=0; i<number_of_shaders; i++)
	{
		printd(NORMAL, "%s\n", shaders[i]->name);
	}
	
	return NULL;
}

shader_data* get_shader(char *name)
{
	int i = 0;

	for(i=0; i<number_of_shaders; i++)
	{
		if(strncmp(shaders[i]->name, name, 50) == 0)
			return shaders[i];
	}
	
	return NULL;
}

shader_data* get_hilight();
shader_data* get_blur();
shader_data* get_invert();
shader_data* get_greyscale();
shader_data* get_convolve();
shader_data* get_bloom();
shader_data* get_blend();
shader_data* get_reproj();
shader_data* get_reproj_blur();

void setup_shaders()
{
	register_shader((shader_data*)get_hilight());
	register_shader((shader_data*)get_greyscale());
	register_shader((shader_data*)get_invert());
	register_shader((shader_data*)get_blur());
	register_shader((shader_data*)get_convolve());
	register_shader((shader_data*)get_bloom());
	register_shader((shader_data*)get_blend());
	register_shader((shader_data*)get_reproj());
	register_shader((shader_data*)get_reproj_blur());
}
