#ifndef SHADERS_H
#define SHADERS_H
#include "../common/scene.h"
#include "../common/Color.h"
#include "../common/debug.h"

void general_shader(intersect_data *i_data, Color* final_Color);
void phong(intersect_data *id, Color *new_Color);
void refract_Color(intersect_data *id, Color* new_Color);
void reflect_Color(intersect_data *id, Color* new_Color);
void trans_Color(intersect_data *id, Color* new_Color);
void distance_shader(intersect_data *i_data, Color* final_Color);
void Primitive_shader(intersect_data *i_data, Color* final_Color);
void normal_shader(intersect_data *i_data, Color* final_Color);
void diffuse_lighting(intersect_data *id, Color *new_Color);
void black_white_filter(intersect_data *id, Color *new_Color);
void lens_filter(intersect_data *id, Color *new_Color);
void portal_filter(intersect_data *id, Color *new_Color);
void sin_filter(intersect_data *id, Color *new_Color);
void wave_shader(intersect_data *i_data, Color* final_Color);
void wire(intersect_data *i_data, Color* final_Color);
void purple_gradiant(intersect_data *id, Color *bg);
void checker_shader(intersect_data *i_data, Color* final_Color);
void relative_normal_shader(intersect_data *i_data, Color* final_Color);
void glossy_reflect_Color(intersect_data *i_data, Color *new_Color);
void shader_shadow_cost(intersect_data *id, Color *new_Color);

void back_black(intersect_data *id, Color *bg);
void back_gray(intersect_data *id, Color *bg);
void back_gradiant(intersect_data *id, Color *bg);
void back_mountains(intersect_data *id, Color *bg);

typedef enum{startup, pre, during, post, after} shader_type;

extern SlimScene *main_scene;

//fragment shaders, buffer filters
typedef struct {
	char *name;
	char *help_text;
	//shader_type type;
	//int type;
	int (*init) (void *container, char *data);
	void* (*run) (void *data);
	void* (*cleanup) (void *data);
	void* data;
} shader_data;

shader_data* get_shader(char *name);
void setup_shaders();
char* list_shaders();
void fill_in_next_hit_data(intersect_data *dest, intersect_data *source);
void copy_hit_data(intersect_data *dest, intersect_data *source);

#define CHECK_STEPS(steps, max) \
	if(steps > max)\
	{\
		printd(DEBUG, "}__FUNCTION__: max recurs\n");\
		return;\
	}

#endif //SHADERS_H
