//slim raytracer
//Copyright 2003, Micah Taylor


#include "slim.h"
#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include "common/Compatible.h"
#include "common/debug.h"
#include "common/scene.h"
#include "load/load.h"
#include "misc/save_frame.h"
#include "frontend/front_init.h"
#include "frontend/display_scene.h"
#include "shader/shaders.h"
#include "Primitives/Sphere.h"

#include "shader/post_shaders.h"
#include "render/photon_map.h"
#include "render/render_scene.h"

#include "misc/FilePath.h"

int render(void);
void render_frame(void);
void setup_default_scene();

//current scene
SlimScene mscene;
SlimScene *main_scene = &mscene;

//current system state
system_data sys_state;
system_data *sys = &sys_state;

int intersects_calced = 0;
int DEBUG_LEVEL = 0;
void (*print_function)(char*, va_list);
void (*print_frame_data)(char*, va_list);
void (*update_frame_output)(SlimScene *scene);
int interpolate_on = 1;
//clock_t current_time;
extern int sim_type;
char debug_ray;

void catch_sigint()
{
	printd(QUIET, "Caught SIGINT. Exiting.\n");
	exit(1);
}

#define MAX_POST_SHADERS 25.0
void setup_default_system()
{
	sys->max_num_threads = 1;
	sys->debug_level = ALERT;
	sys->max_height = 100;
	sys->max_width = 100;
	
	//add post shaders
//	list_make(&sys->post_shaders, MAX_POST_SHADERS);
//	list_add_item(&sys->post_shaders, (void*)get_invert(), "invert");
	
	list_make(&sys->active_post_shaders, MAX_POST_SHADERS, 1);
	//list_add_item(&sys->active_post_shaders, list_get_name(&sys->post_shaders,"invert"), NULL);
}

int main(int argc, char** argv)
{
//#ifndef WIN32
// 	signal(SIGINT, catch_sigint);
//#endif

	// seed random numbers
	timeval t;
	gettimeofday(&t, NULL);
	srand(t.tv_sec * t.tv_usec);

	
	debug_ray = 0;
	
	// setup default print functions
	print_function = print_to_stdout;
	print_frame_data = print_to_stdout;
	update_frame_output = (void (*)(SlimScene*))save_frame;

	// setup default reder engine
	setup_default_system();
	setup_default_scene();
	DEBUG_LEVEL = sys->debug_level;
	//setup_intersect();
	setup_shaders();

	// load scene data
	init_scene(argc, argv, main_scene);

	// photon mapping
	//srand(1);
	//PhotonMap p;
	//p.createMaps(main_scene, 5000);
	//p.balanceMaps();
	
	//render_scene(183);
	//add_post_shader(get_shader("reproj_blur"), NULL);
	render();

	return 0;
}

void setup_default_scene()
{
	main_scene->camera = (Camera*) malloc( sizeof(Camera));
	main_scene->camera->pos = vector3(0, 0, 0);
	main_scene->camera->look = vector3(0, 0, 0);
	main_scene->camera->lookAtPoint = vector3(0, 0, 0);
	main_scene->camera->up = vector3(0, 0, 0);
	//main_scene->camera->units = 0;
	debug_ray = 0;
	
	main_scene->width = 20000;
	main_scene->height = 20000;
	main_scene->sub_dis = 1;
	main_scene->sub_var = 1;
	main_scene->sub_level = 1;
}

int render()
{
	//render_frame();
	//generate_subs();
	//generate_srays();
	//normal_sampler();
	//deferred_renderer();
	//save_frame(main_scene);
	//render_scene(183);
	frontend_init();
	display_scene_loop(main_scene);

	return 1;
}
